
**********************************************************************
*This program produce data for Figure 12 and 13
**********************************************************************
use "$path\data\redraw_HES.dta" 
*merge with household-level data 
merge m:1  abshid year using "$path\data\2004_2018withHES.dta", nogen

su hh_redraw, de
replace hh_redraw=. if hh_redraw>1000000 & hh_redraw!=. //get rid of outliers 

drop if year==2008 //wealth variables in 2008 are not available 
//offset accounts is separated from deposits from 2010/11
replace off=0 if off==.


//replace negative values with zero
replace dinc=0 if dinc<0
replace dinc=0 if dinc==.
replace debts=0 if debts<0

*Annual disposable income
g adinc = dinc*52

********household liquidity buffer***********
*Baseline buffer: Liquid assets //bank is sum of offset and deposit 
g liqassets = bank + shares + bonds +trust
gen buffer=liqassets/adinc*12
summarize buffer, detail
replace buffer=. if buffer>200

*Buffer excludes offset
g liqassets_nooff = bank + shares + bonds +trust - off if year>2010 //we only see offset separately after 2010/2011 
g buffer_nooff=liqassets_nooff/adinc*12 
replace buffer_nooff=. if buffer_nooff>200 

*Buffer includes estimated redraw 
gen liqassets_redraw=liqassets+hh_redraw
gen buffer_re=liqassets_redraw/adinc*12
replace buffer_re=. if buffer_re>200
  

********household liquid to total assets ratio*******
replace assets=0 if assets<0  
*Baseline
gen liq_tot=liqassets/assets*100

*excludes offset
*need to exclude offset from the denominator 
gen liq_tot_nooff=liqassets_nooff/(assets-off)*100

*includes redraw 
*need to include redraw in the denominator
gen liq_tot_re=liqassets_redraw/(assets+hh_redraw)*100 



*Liquid debt (credit card debt)
g liq_debt = ccdebt 

*Liquid net wealth 
g liqnw = liqassets - liq_debt

*liquid net wealth with redraw
g liqnw_re=liqassets_redraw - liq_debt

*I think this is total housing equity, including investments (but should check)
g house_equity = resassets - resdebt

*Illiquid net wealth 
g illiqnw = house_equity + super

*Set fortnightly household income
*g pay = dinc_prev/26
g pay = dinc*52/26

*Set household credit limit to one month of income (from Kaplan)
g credit_limit = dinc*52/12

*HTM households 
g htm=0
replace htm=1 if (pay/2>=liqnw & liqnw>=0)
replace htm=1 if (pay/2-credit_limit>=liqnw & liqnw<=0)



g wealthy_htm= (htm==1 & illiqnw>0)
g poor_htm= ( htm==1 & illiqnw<=0)


*********DTI***********
*gross DTI
gen dti=debts/adinc 
*net DTI 
gen net_dti=(debts-liqassets)/adinc

*net DTI net of liquid assets (including redraw)
gen net_dti_re=(debts-liqassets_redraw)/adinc 

*housing DTI
gen dti_mort=hdebt/adinc 
* housing dti net of liquid assets (including redraw)
gen net_dti_mort_re=(hdebt-liqassets_redraw)/adinc 



replace dinc=0 if dinc<0
gen dinc_m=dinc*52/12
forvalues i=1/360{
gen principal_payment_dinc_`i'=principal_payment_`i'/dinc_m if `i'==loan_age_months
gen interest_payment_dinc_`i'=interest_payment_`i'/dinc_m if `i'==loan_age_months

}
order *, sequential

egen princ_dinc= rowmax(principal_payment_dinc_1-principal_payment_dinc_360)
egen int_dinc= rowmax(interest_payment_dinc_1-interest_payment_dinc_360)

replace princ_dinc=princ_dinc*100
replace int_dinc=int_dinc*100

su dinc, de
keep if inrange(dinc, r(p0), r(p99))
keep if princ_dinc<100
keep if int_dinc<100 

gen after2010=0
replace after2010=1 if year_loan_originated>=2010
replace after2010=. if year_loan_originated==. 



***RDP graph data****

*Figure 12: Mortgage Debt and Household Liquidity, by loan age and birth cohort
*3-panel: Top panel is gross/net DTI; middle-panel is liquid assets to income ratio; bottom panel is share of htm hosueholds 

*NB: there are both HES 2004 and SIH 2004 household data in the sample, get rid of the SIH 2004 data 
gen buffer_re_annual=liqassets_redraw/adinc

drop if HESHHWT==. & year==2004 
replace hwt=HESHHWT if year==2004 


tabstat  dti_mort net_dti_mort_re buffer_re_annual htm [aw=hwt] if mortgagor==1 & dti_mort<50 & loan_after2010==1  , by(loan_age) 
tabstat  dti_mort net_dti_mort_re buffer_re_annual htm [aw=hwt] if mortgagor==1 & dti_mort<50 & loan_after2010==0  , by(loan_age) 

*Figure 13: Mortgage repayment, share of household disposable income 
collapse(mean) princ_dinc int_dinc , by(loan_age after2010)





